#ifndef KRAMPUS_INC_KITTEN_HPP
#define KRAMPUS_INC_KITTEN_HPP

#include <string>
#include <vector>
#include <iostream>

#include <allegro5/allegro.h>
#include <allegro5/allegro_audio.h>

#include <inc/map.hpp>
#include <inc/random.hpp>

using std::cout;
using std::string;
using std::vector;

class Kitten {

  public:

    Kitten(void);

    bool isFound(void);

    float getX(void);

    float getY(void);

    void move(const float, const float);

    void find(ALLEGRO_SAMPLE *);

    void spawn(void);

    void update(void);

    void render(const float, const float, ALLEGRO_BITMAP *);

    void moveUp(void);

    void moveDown(void);

    void moveLeft(void);

    void moveRight(void);

    void setFacingDirection(const unsigned int);

    void setRandomNumberGenerator(Random *);

    void setMap(Map *);

    void setName(const string);

    string getName(void);

  private:

    bool found;

    int kitten_type;

    string name;

    int start_tile;
    int stop_tile;

    unsigned int facing;

    unsigned int timer;
    unsigned int duration;

    bool reset;

    unsigned int ticks;
    unsigned int frame;

    bool keys[4];
    bool moving[4];
    bool is_moving;

    float x;
    float y;

    enum FacingDirections {LEFT = 0, RIGHT};

    bool facing_direction[2];

    float move_speed;

    Map *TileMap;
    Random *RandomNumberGenerator;
};

#endif
